<?php

namespace App\Models;

use Illuminate\Contracts\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class Pembayaran extends Model
{
    use HasFactory;
    protected $fillable = [
        'transaksi_id',
        'bank_id',
        'sts_transfer',
        'struk',
        'expired',
        'tgl_bayar',
        'tgl_diterima',
    ];

    public function transaksi(): BelongsTo
    {
        return $this->belongsTo(Transaksi::class);
    }

    public function modull(): BelongsTo
    {
        return $this->belongsTo(Modul::class);
    }

    public function scopePencarian(Builder $query): void
    {
        $cari = request('cari');
        $query->whereHas('transaksi', function ($query) use ($cari) {
            $query->where('kd_transaksi', 'like', '%' .  $cari . '%')
                ->orwhereHas('member', function ($query) {
                    $query->where('nm_member', 'like', '%' .  request('cari') . '%');
                });
        });
    }
}
